﻿$SourceDatabase = 'AdventureWorks2016' #where we take the data and build script from 
$SourceServerName = 'PentlowMillServ'
$SourceLogin = 'PhilFactor' #Leave blank for Windows authentication

#none of our errors are recoverable
$ErrorActionPreference = "Stop"
$MS = 'Microsoft.SQLServer'
#create a connection object as we can reuse this for all the operations
# is this Windows Authentication or UserID/Password credentials?
$connection = New-Object -TypeName System.Data.SqlClient.SqlConnection
$connectionString = "Server=$SourceServerName;Database=$SourceDatabase;Integrated Security=True;"
if ($SourceLogin -ne '') #if no login specified, then it was a windows login
{
	$connectionString = "Server=$SourceServerName;Database=$SourceDatabase;Integrated Security=False;"
	if (Test-Path -path "$env:USERPROFILE\$SourceLogin-$SourceServerName.txt" -PathType leaf)
	{
		#has already got this set for this login so fetch it
		$encrypted = Get-Content "$env:USERPROFILE\$SourceLogin-$SourceServerName.txt" | ConvertTo-SecureString
		$encrypted.MakeReadOnly()
		$Credentials = New-Object System.Data.SqlClient.SqlCredential($SourceLogin, $encrypted)
	}
	else
	{
		#hasn't got this set for this login
		$AutomationCredentials = get-credential -Credential $SourceLogin
		$AutomationCredentials.Password | ConvertFrom-SecureString | Set-Content  "$env:USERPROFILE\$SourceLogin-$SourceServerName.txt"
		($password = $AutomationCredentials.Password).MakeReadOnly()
		$Credentials = New-Object System.Data.SqlClient.SqlCredential(($AutomationCredentials.UserName -replace '^.*\\|@.*$'), $password)
	}
}
$connection.Credential = $Credentials
$connection.ConnectionString = $connectionString
$connection.Open() | out-null
$handler = [System.Data.SqlClient.SqlInfoMessageEventHandler] { param ($sender,
		$event)    $global:message = "$($message)`n $($event.Message)" };
$connection.add_InfoMessage($handler);
$connection.FireInfoMessageEventOnUserErrors = $true

do
{
	
	@(('Saint Germain en Laye'), ('Findon'), ('Bonn'), ('Mühlheim'), ('Olympia'), ('Berks'),
		('Canoga Park'), ('Corvallis'), ('Silverwater'), ('Goulburn'), ('Gold Coast'), ('Paris'),
		('Langley'), ('Kirkland'), ('South Melbourne'), ('Calgary'), ('Dresden'), ('Darlinghurst'),
		('Bell Gardens'), ('Milsons Point'), ('Branson'), ('Downey'), ('San Francisco'), ('Ballard'),
		('Westminster'), ('Morangis'), ('Newcastle upon Tyne'), ('Metchosin'), ('Shawnee'), ('Les Ulis'),
		('Hannover'), ('Geelong'), ('Poing'), ('Sedro Woolley'), ('Chicago'), ('Everett'), ('Saint-Denis'),
		('Oxford'), ('Münster'), ('Port Hammond'), ('Columbus'), ('Colomiers'), ('Lavender Bay'),
		('Bothell'), ('Grossmont'), ('Darmstadt'), ('Sooke'), ('Clearwater'), ('Santa Cruz'), ('Fremont'),
		('Woodburn'), ('Tremblay-en-France'), ('Bottrop'), ('Sydney'), ('Victoria'), ('Seattle'), ('Bury'),
		('Leeds'), ('Drancy'), ('Orleans'), ('Glendale'), ('Matraville'), ('Melton'), ('Malabar'), ('Paris La Defense'),
		('Beaverton'), ('Maidenhead'), ('Runcorn'), ('Billericay'), ('Erlangen'), ('Cranbourne'), ('Paderborn'),
		('Springwood'), ('El Cajon'), ('Wokingham'), ('Berkshire'), ('Branch'), ('Lake Oswego'), ('Oregon City'),
		('Burnaby'), ('Lemon Grove'), ('Boulogne-sur-Mer'), ('Woolston'), ('Santa Monica'), ('Spring Valley'),
		('Clay'), ('Saint Ouen'), ('Hobart'), ('Chatou'), ("Villeneuve-d'Ascq"), ('Bluffton'), ('Oakland'),
		('East Brisbane'), ('High Wycombe'), ('Lakewood'), ('York'), ('Coffs Harbour'), ('Reading'),
		('Orly'), ('Basingstoke Hants'), ('Carol Stream'), ('Lincoln Acres'), ('Los Angeles'), ('Coronado'),
		('Beverly Hills'), ('Cliffside'), ('Roissy en Brie'), ('Colombes'), ('Bendigo'), ('Gloucestershire'),
		('San Diego'), ('Birmingham'), ('Pantin'), ('Issaquah'), ('Saarlouis'), ('Port Macquarie'),
		('Melbourne'), ('Bellflower'), ('Mill Valley'), ('La Jolla'), ('Yakima'), ('North Sydney'),
		('Port Orchard'), ('Cheektowaga'), ('Marysville'), ('Novato'), ('Imperial Beach'), ('Grevenbroich'),
		('Bobigny'), ('West Sussex'), ('London'), ('National City'), ('Clarkston'), ('Langford'), ('Redmond'),
		('Duesseldorf'), ('Frankfurt'), ('Braunschweig'), ('Ingolstadt'), ('West Covina'), ('North Ryde'),
		('Walla Walla'), ('Sulzbach Taunus'), ('Metz'), ('Lebanon'), ('College Station'), ('Cheltenham'),
		('W. York'), ('Sèvres'), ('Dunkerque'), ('Lynnwood'), ('Warrnambool'), ('Campbellsville'),
		('Sunbury'), ('Royal Oak'), ('Rockhampton'), ('Kiel'), ('Leipzig'), ('Portland'), ('Clackamas'),
		('Palo Alto'), ('Redwood City'), ('Concord'), ('Verrieres Le Buisson'), ('Newton'), ('Newport Beach'),
		('San Carlos'), ('Central Valley'), ('Cambridge'), ('Bellingham'), ('Watford'), ('Neunkirchen'),
		('Boulogne-Billancourt'), ('Suresnes'), ('Daly City'), ('Warrington'), ('München'), ('Cergy'),
		('Vancouver'), ('Chehalis'), ('Long Beach'), ('Carson'), ('Berkeley'), ('Lane Cove'), ('Renton'),
		('Perth'), ('Hof'), ('Gateshead'), ('Berlin'), ('Haney'), ('Kassel'), ('Woodland Hills'),
		('St. Leonards'), ('Milton Keynes'), ('Stoke-on-Trent'), ('Versailles'), ('Lieusaint'),
		('Townsville'), ('Burlingame'), ('Courbevoie'), ('Rhodes'), ('Tacoma'), ('Bremerton'), ('Lille'),
		('Oak Bay'), ('Roncq'), ('Roubaix'), ('Wollongong'), ('Chantilly'), ('Solingen'), ('Cincinnati'),
		('Bracknell'), ('Caloundra'), ('Cedar Park'), ('Oxon'), ('Carrollton'), ('Edmonds'), ('Kirkby'),
		('Salem'), ('Peterborough'), ('Salzgitter'), ('Saarbrücken'), ('Offenbach'), ('Colma'), ('Charlotte'),
		('Burbank'), ('Brisbane'), ('Byron'), ('Cloverdale'), ('Puyallup'), ('Hamburg'), ('Croix'), ('Spokane'),
		('Cheyenne'), ('Burien'), ('Torrance'), ('Seaford'), ('Lancaster'), ('W. Linn'), ('Hawthorne'), ('Liverpool'),
		('Essen'), ('Frankfurt am Main'), ('Chula Vista'), ('Milwaukie'), ('Stuttgart'), ('Newcastle'),
		('Werne'), ('N. Vancouver'), ('Hervey Bay'), ('San Gabriel'), ('Eilenburg'), ('Esher-Molesey')
	) | foreach{
		$cmd = new-Object System.Data.SqlClient.SqlCommand(@'
SELECT DISTINCT Person.FirstName + ' ' + Person.LastName,
  Address.AddressLine1 + Coalesce(Address.AddressLine2, '') + ', '
  + Address.City + ' ' + Address.PostalCode
  FROM Sales.SalesOrderHeader
    INNER JOIN Person.Person
      ON SalesOrderHeader.CustomerID = Person.BusinessEntityID
    INNER JOIN Person.Address
      ON Address.AddressID = SalesOrderHeader.BillToAddressID
  WHERE Address.City LIKE @city
'@, $connection)
		$cmd.Parameters.Add("@city", [system.data.SqlDbType]::NVarChar) | out-Null
		$cmd.Parameters['@city'].Size = 40
		$cmd.Parameters['@city'].value = $_
		Start-Sleep -seconds (get-random -maximum 10 -minimum 1)
		$rdr = $cmd.ExecuteReader() #because we are getting a result back
		do
		{
			$datatable = new-object System.Data.DataTable
			$datatable.Load($rdr)
			$datatable | Format-table
		}
		while ($rdr.IsClosed -eq $false)
		$rdr.Close()
	}
}
While ($true -eq $true)