﻿$SourceDatabase = 'AdventureWorks2016' #where we take the data and build script from 
$SourceServerName = 'PentlowMillServ'
$SourceLogin = 'PhilFactor' #Leave blank for Windows authentication

#none of our errors are recoverable
$ErrorActionPreference = "Stop"
$MS = 'Microsoft.SQLServer'
#create a connection object as we can reuse this for all the operations
# is this Windows Authentication or UserID/Password credentials?
$connection = New-Object -TypeName System.Data.SqlClient.SqlConnection
$connectionString = "Server=$SourceServerName;Database=$SourceDatabase;Integrated Security=True;"
if ($SourceLogin -ne '') #if no login specified, then it was a windows login
{
	$connectionString = "Server=$SourceServerName;Database=$SourceDatabase;Integrated Security=False;"
	if (Test-Path -path "$env:USERPROFILE\$SourceLogin-$SourceServerName.txt" -PathType leaf)
	{
		#has already got this set for this login so fetch it
		$encrypted = Get-Content "$env:USERPROFILE\$SourceLogin-$SourceServerName.txt" | ConvertTo-SecureString
		$encrypted.MakeReadOnly()
		$Credentials = New-Object System.Data.SqlClient.SqlCredential($SourceLogin, $encrypted)
	}
	else
	{
		#hasn't got this set for this login
		$AutomationCredentials = get-credential -Credential $SourceLogin
		$AutomationCredentials.Password | ConvertFrom-SecureString | Set-Content  "$env:USERPROFILE\$SourceLogin-$SourceServerName.txt"
		($password = $AutomationCredentials.Password).MakeReadOnly()
		$Credentials = New-Object System.Data.SqlClient.SqlCredential(($AutomationCredentials.UserName -replace '^.*\\|@.*$'), $password)
	}
}
$connection.Credential = $Credentials
$connection.ConnectionString = $connectionString
$connection.Open() | out-null
$handler = [System.Data.SqlClient.SqlInfoMessageEventHandler] { param ($sender,
		$event)    $global:message = "$($message)`n $($event.Message)" };
$connection.add_InfoMessage($handler);
$connection.FireInfoMessageEventOnUserErrors = $true
do
{
	
	@('vest', 'gloves', 'touring frame', 'Road Frame', 'jersey', 'shorts',
		'helmet', 'tights', 'wheel', 'handlebars', 'pedal', 'bracket', 'seat',
		'saddle', 'chain', 'fork', 'tube', 'pump', 'brakes') | foreach{
		$cmd = new-Object System.Data.SqlClient.SqlCommand(@"
SELECT Product.Name, Product.ProductNumber, Product.Color, Product.ListPrice
  FROM Production.Product
 WHERE Product.Name LIKE '%$($_)%'
  AND Product.ProductModelID IN
          (
          SELECT p1.ProductModelID
            FROM Production.Product AS p1
            GROUP BY ProductModelID
            HAVING Max(p1.ListPrice) >=ALL
              (
              SELECT Avg(p2.ListPrice)
                FROM Production.Product AS p2
                WHERE p1.ProductModelID = p2.ProductModelID
              )
          );
"@, $connection)
		Start-Sleep -seconds (get-random -maximum 10 -minimum 1)
		$rdr = $cmd.ExecuteReader() #because we are getting a result back
		do
		{
			$datatable = new-object System.Data.DataTable
			$datatable.Load($rdr)
			$datatable | Format-table
		}
		while ($rdr.IsClosed -eq $false)
		$rdr.Close()
	}
}
While ($true -eq $true)