﻿$SourceDatabase = 'AdventureWorks2016' #where we take the data and build script from 
$SourceServerName = 'PentlowMillServ'
$SourceLogin = 'PhilFactor' #Leave blank for Windows authentication

#none of our errors are recoverable
$ErrorActionPreference = "Stop"
$MS = 'Microsoft.SQLServer'
#create a connection object as we can reuse this for all the operations
# is this Windows Authentication or UserID/Password credentials?
$connection = New-Object -TypeName System.Data.SqlClient.SqlConnection
$connectionString = "Server=$SourceServerName;Database=$SourceDatabase;Integrated Security=True;"
if ($SourceLogin -ne '') #if no login specified, then it was a windows login
{
	$connectionString = "Server=$SourceServerName;Database=$SourceDatabase;Integrated Security=False;"
	if (Test-Path -path "$env:USERPROFILE\$SourceLogin-$SourceServerName.txt" -PathType leaf)
	{
		#has already got this set for this login so fetch it
		$encrypted = Get-Content "$env:USERPROFILE\$SourceLogin-$SourceServerName.txt" | ConvertTo-SecureString
		$encrypted.MakeReadOnly()
		$Credentials = New-Object System.Data.SqlClient.SqlCredential($SourceLogin, $encrypted)
	}
	else
	{
		#hasn't got this set for this login
		$AutomationCredentials = get-credential -Credential $SourceLogin
		$AutomationCredentials.Password | ConvertFrom-SecureString | Set-Content  "$env:USERPROFILE\$SourceLogin-$SourceServerName.txt"
		($password = $AutomationCredentials.Password).MakeReadOnly()
		$Credentials = New-Object System.Data.SqlClient.SqlCredential(($AutomationCredentials.UserName -replace '^.*\\|@.*$'), $password)
	}
}
$connection.Credential = $Credentials
$connection.ConnectionString = $connectionString
$connection.Open() | out-null
$handler = [System.Data.SqlClient.SqlInfoMessageEventHandler] { param ($sender,
		$event)    $global:message = "$($message)`n $($event.Message)" };
$connection.add_InfoMessage($handler);
$connection.FireInfoMessageEventOnUserErrors = $true
do
{
	@(('Mary', 'Young'), ('Amber', 'Young'), ('Courtney', 'Young'), ('Jenna', 'Young'), ('Chloe', 'Harris'), ('Joe', 'Madan'),
		('Chloe', 'Martin'), ('Marshall', 'Xu'), ('Joe', 'Srini'), ('Joe', 'Prasad'), ('Joe', 'Schmidt'), ('Joe', 'Rana'),
		('Chloe', 'Thompson'), ('Joe', 'Raman'), ('Chloe', 'Garcia'), ('Joe', 'Subram'), ('Chloe', 'Robinson'), ('Chloe', 'Clark'),
		('Joe', 'Mehta'), ('Joe', 'Belson'), ('Chloe', 'Rodriguez'), ('Cindy', 'Lewis'), ('Joe', 'Lopez'), ('Chloe', 'Lee'),
		('Chloe', 'Walker'), ('Marshall', 'Sun'), ('Joe', 'Martinez'), ('Chloe', 'Hall'), ('Julia', 'Smith'), ('Joe', 'Gonzalez'),
		('Julia', 'Johnston'), ('Julia', 'Williams'), ('Joe', 'Sanchez'), ('Julia', 'Jones'), ('Joe', 'Perez'), ('Julia', 'Brown'),
		('Joe', 'Martin'), ('Joe', 'Gomez'), ('Joe', 'Diaz'), ('Julia', 'Davis'), ('Joe', 'Hernandez'), ('Marshall', 'Zhu'),
		('Joe', 'Ashe'), ('Joe', 'Jimenez'), ('Joe', 'Moreno'), ('Julia', 'Miller'), ('Julia', 'Wilson'), ('Julia', 'Moore'),
		('Julia', 'Taylor'), ('Julia', 'Anderson')) | foreach{
		$cmd = new-Object System.Data.SqlClient.SqlCommand(@'
SELECT Person.FirstName + ' ' + Person.LastName as Name,
  Address.AddressLine1 + ', ' + Coalesce(Address.AddressLine2 + ', ', '')
  + Address.City + ' ' + Address.PostalCode as address
  FROM Sales.SalesOrderHeader
    INNER JOIN Person.Person
      ON SalesOrderHeader.CustomerID = Person.BusinessEntityID
    INNER JOIN Person.Address
      ON Address.AddressID = SalesOrderHeader.BillToAddressID
  WHERE Person.FirstName like @fn AND Person.LastName like @ln
'@, $connection)
		$cmd.Parameters.Add("@fn", [system.data.SqlDbType]::NVarChar) | out-Null
		$cmd.Parameters['@fn'].Size = 30
		$cmd.Parameters['@fn'].value = $_[0]
		$cmd.Parameters.Add("@ln", [system.data.SqlDbType]::NVarChar) | out-Null
		$cmd.Parameters['@ln'].Size = 30
		$cmd.Parameters['@ln'].value = $_[1]
		Start-Sleep -seconds (get-random -maximum 10 -minimum 1)
		
		$rdr = $cmd.ExecuteReader() #because we are getting a result back
		do
		{
			$datatable = new-object System.Data.DataTable
			$datatable.Load($rdr)
			$datatable | Format-table
		}
		while ($rdr.IsClosed -eq $false)
		$rdr.Close()
	}
}
While ($true -eq $true)