/*
|| Script:  vector-tile-caching.sql
|| Purpose: Shows various aspects of the new 23ai vector tile caching capabilities
|| Author:  Jim Czuprynski, Zero Defect Computing, Inc.
*/

-----
-- Enables vector tile caching for the GEOMETRY column in EXISTING_WIND_TURBINES 
-- and EXISTING_PV_SITES tableS. Any other columns of datatype SDO_GEOMETRY for 
-- those tables will not be cached unless specifically enabled
-----
BEGIN
   SDO_UTIL.ENABLE_VECTORTILE_CACHE(
     table_name => 'EXISTING_WIND_TURBINES'
   , geom_col_name => 'GEOMETRY'
   , ts_name => 'DATA'
   , min_zoom => 0
   , max_zoom => 23
   );

   SDO_UTIL.ENABLE_VECTORTILE_CACHE(
     table_name => 'EXISTING_PV_SITES'
   , geom_col_name => 'GEOMETRY'
   , ts_name => 'DATA'
   , min_zoom => 0
   , max_zoom => 23
   );

END;
/

-----
-- View vector tile caching metadata:
-----

-- View all cached vector tiles for this schema
SELECT *
  FROM SDO_VECTOR_TILE_CACHE$INFO;
    
-- View all cached vector tile data for this schema
SELECT *
  FROM SDO_VECTOR_TILE_CACHE$TABLE;
  
-----
-- Disables vector tile caching for just the GEOMETRY column in the 
-- EXISTING_WIND_TURBINES table. Any other SDO_GEOMERTY columns already 
-- being cached for that table are still held in cache
-----
BEGIN
   SDO_UTIL.DISABLE_VECTORTILE_CACHE(
     table_name => 'EXISTING_WIND_TURBINES'
   , geom_col_name => 'GEOMETRY'
   );
END;
/

-----
-- Purges all cached vector tile data for the EXISTING_WIND_TURBINES table
-----
BEGIN
   SDO_UTIL.PURGE_VECTORTILE_CACHE(table_name => 'EXISTING_WIND_TURBINES');
END;
/

-----
-- Grants the GEOSWARM schema access to all vector tile caches
-- owned but the executing schema
----- 
BEGIN
   SDO_UTIL.GRANT_VECTORTILE_CACHE(
     schema_name => 'GEOSWARM'
   , read_only => TRUE
   );
END;
/

-----
-- Revokes access to all vector tile caches owned but the executing 
-- schema to the GEOSWARM schema 
----- 
BEGIN
   SDO_UTIL.REVOKE_VECTORTILE_CACHE(schema_name => 'HOL23');
END;
/

